#ifndef TLIGHTTAG_H
#define TLIGHTTAG_H

enum
{
    TACHYON_LIGHTTAG_AREA_LIGHT_SETTINGS = 1000,

	TACHYON_LIGHTTAG_SHADOW_MODE = 1001,
		TACHYON_LIGHTTAG_SHADOW_MODE_NONE = 0,
		TACHYON_LIGHTTAG_SHADOW_MODE_HARD = 1,
		TACHYON_LIGHTTAG_SHADOW_MODE_FILTERED = 2,
		TACHYON_LIGHTTAG_SHADOW_MODE_CONTACT_HARDENING = 3,

    TACHYON_LIGHTTAG_SOFT_SHADOW_MODE = 1020,
        TACHYON_LIGHTTAG_SOFT_SHADOW_MODE_MVR = 1,
        TACHYON_LIGHTTAG_SOFT_SHADOW_MODE_PCSS = 2,

    // TACHYON_LIGHTTAG_SHADOW_LIGHT_WIDTH = 1003, deprecated

	TACHYON_LIGHTTAG_SHADOW_ABSOLUTE_BIAS = 1004,
	TACHYON_LIGHTTAG_SHADOW_SLOPE_BIAS = 1006,

	TACHYON_LIGHTTAG_INTENSITY = 1007,
    TACHYON_LIGHTTAG_ONE_SIDED_EMISSION = 1008,

	TACHYON_LIGHTTAG_SHADOW_SAMPLE_SIZE = 1014,
	TACHYON_LIGHTTAG_SHADOW_COLOR = 1005,

	TACHYON_LIGHTTAG_FALLOFF_OUTER_RADIUS = 1015,
	TACHYON_LIGHTTAG_FALLOFF_INNER_RADIUS = 1016,

	TACHYON_LIGHTTAG_CLIP_NEAR_ENABLED = 1101,
	TACHYON_LIGHTTAG_CLIP_NEAR_FROM = 1102,
	TACHYON_LIGHTTAG_CLIP_NEAR_TO = 1103,

	TACHYON_LIGHTTAG_CLIP_FAR_ENABLED = 1104,
	TACHYON_LIGHTTAG_CLIP_FAR_FROM = 1105,
	TACHYON_LIGHTTAG_CLIP_FAR_TO = 1106,
			
	TACHYON_LIGHTTAG_ATTENUATION_PRESET = 1022,
		TACHYON_LIGHTTAG_ATTENUATION_PRESET_CUSTOM = 0,
		TACHYON_LIGHTTAG_ATTENUATION_PRESET_1 = 1,	// FALLOFF_NONE
		TACHYON_LIGHTTAG_ATTENUATION_PRESET_2 = 2,	// FALLOFF_LINEAR
		TACHYON_LIGHTTAG_ATTENUATION_PRESET_3 = 3,	// FALLOFF_INVERSE_SQUARED
		TACHYON_LIGHTTAG_ATTENUATION_PRESET_4 = 4,	// FALLOFF_INVERSE_SQUARED_LIMITED
		TACHYON_LIGHTTAG_ATTENUATION_PRESET_5 = 5,	// FALLOFF_STEP

	TACHYON_LIGHTTAG_LIGHT_COLOR = 1028,
	TACHYON_LIGHTTAG_TYPE		 = 1029,
		TACHYON_LIGHTTAG_TYPE_OMNIDIRECTIONAL   = 0,
		TACHYON_LIGHTTAG_TYPE_SPOTLIGHT			= 1,
        TACHYON_LIGHTTAG_TYPE_INFINITE_LIGHT    = 2,
        TACHYON_LIGHTTAG_TYPE_AREA_LIGHT	    = 3,
	
	TACHYON_LIGHTTAG_LIGHT_CONE_INNER_ANGLE = 1030,
	TACHYON_LIGHTTAG_LIGHT_CONE_OUTER_ANGLE = 1031,

    // enum values must be in sync with tachyon::shared::AreaLightShape
    TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE = 1040,
        TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_DISC = 0,
        TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_RECTANGLE = 1,
        TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_SPHERE = 3,
        TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_CYLINDER = 4,
        TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_CUBE = 5,
        TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_HEMISPHERE = 6,
        //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_OBJECT = 6,
        TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_LINE = 2,
        //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_PCYLINDER = 8,
    TACHYON_LIGHTTAG_AREA_LIGHT_SIZEX = 1041,
    TACHYON_LIGHTTAG_AREA_LIGHT_SIZEY = 1042,
    TACHYON_LIGHTTAG_AREA_LIGHT_SIZEZ = 1043,
    TACHYON_LIGHTTAG_AREA_LIGHT_SHOW_SURFACE = 1044,

	TACHYON_LIGHTTAG_DIFFUSE_ENABLED = 1032,
	TACHYON_LIGHTTAG_SPECULAR_ENABLED = 1033,
    TACHYON_LIGHTTAG_VOLUMETRICS_ENABLED = 1034,

	TACHYON_SHADOW_GROUP = 1050,
	TACHYON_GENERAL_GROUP = 1051,
    TACHYON_SHADOW_GROUP_VOLUMETRICS = 1055,

	TACHYON_LIGHTTAG_SHADOW_CASCADE_COUNT = 1500,
	TACHYON_LIGHTTAG_SHADOW_CASCADE_SPLIT_WEIGHT = 1501,

	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE = 1502,
	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_USE_DEFAULT = 0,
	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_256 = 1,
	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_512 = 2,
	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_1024 = 3,
	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_2048 = 4,
	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_4096 = 5,
	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_8192 = 6,
	TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_16384 = 7,

    TACHYON_LIGHTTAG_SHADOW_MAP_CUSTOM_SHADOW_RANGE = 1503,
    TACHYON_LIGHTTAG_SHADOW_MAP_AUTOMATIC_SHADOW_RANGE_ENABLED = 1504,

    TACHYON_LIGHTTAG_VOLUMETRICS_CAST_OBJECT_SHADOWS = 1511,

    TACHYON_LIGHTTAG_VOLUMETRICS_EXTINCTION_SHADOWS_ENABLED = 1600,
    TACHYON_LIGHTTAG_VOLUMETRICS_EXTINCTION_RESOLUTION_XYZ = 1610,
    TACHYON_LIGHTTAG_VOLUMETRICS_EXTINCTION_RESOLUTION_SCALE = 1620,
	TACHYON_LIGHTTAG_VOLUMETRICS_EXTINCTION_SHADOW_RANGE = 1630,
};

#endif
